unit fOrder;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ComCtrls, ORFn, ORNet, ExtCtrls, Buttons;

type
  TfrmOrder = class(TForm)
    hcOrder: THeaderControl;
    lbOrder: TORListBox;
    pnl1: TPanel;
    btnDet: TButton;
    btnSel: TButton;
    btnPrint: TButton;
    btnQuit: TBitBtn;
    lbTemp: TORListBox;
    procedure btnQuitClick(Sender: TObject);
    procedure lbOrderDblClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure btnSelClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOrder: TfrmOrder;

procedure CurrentOrder;

implementation

{$R *.dfm}

uses SCMMain, fWait, fRptBox, fGenPrint;

procedure CurrentOrder;
begin
  frmOrder := TfrmOrder.Create(Application);
  try
  with frmOrder do
    begin
      CallV('APTWL GET ORDERS', [DFN]);
      lboRDER.Items := RPCBrokerV.Results;
      Caption := Caption + PtName;
      ShowModal;
    end;
  finally
    frmOrder.Release;
  end;

end;

procedure TfrmOrder.btnQuitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmOrder.lbOrderDblClick(Sender: TObject);
var
  IFN: string;
begin
  IFN := piece(lbOrder.Items[lbOrder.ItemIndex], '^', 1);
  CallV('ORQOR DETAIL', [IFN, PatientDFN]);
  ReportBox(RPCBrokerV.Results, 'Order Details for ' + PtName + '  (' + IFN + ')', True);
end;

procedure TfrmOrder.btnDetClick(Sender: TObject);
begin
  lbOrderDblClick(Self);
end;

procedure TfrmOrder.btnSelClick(Sender: TObject);
var
  ifn: string;
begin
  ifn := piece(lbOrder.Items[lbOrder.ItemIndex], '^', 1);
  if frmWait.pcMed.ActivePage = frmWait.TabSheet1 then frmWait.edCon1.Text := ifn;
  if frmWait.TabSheet2.Focused = True then frmWait.edCon2.Text := ifn;
  if frmWait.TabSheet3.Focused = True then frmWait.edCon3.Text := ifn;
  if frmWait.TabSheet4.Focused = True then frmWait.edCon4.Text := ifn;
  Exit;
end;

procedure TfrmOrder.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbTemp.Items.Clear;
  for J := 0 to hcOrder.Sections.Count-1 do lbTemp.Items.Add(hcOrder.Sections[J].Text);
  Title := frmOrder.Caption;
  GenPrint(lbOrder, Title, lbOrder.Pieces, lbOrder.TabPositions, lbTemp);
end;

end.
